package gov.va.genisis2.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * Data Transfer Object (DTO) to transfer study approval related details
 * 
 * @author Prasad Thummalapalli
 *
 */
@XmlRootElement(name = "studyApproval")
@JsonInclude(Include.NON_NULL)
@JsonIgnoreProperties({ "processId", "approvalIdObtained", "modifiedOn", "associatedStudyApproval1", "associatedStudyApproval2", "associatedStudyApproval3", "requests" })
public class StudyApprovalDTO implements Serializable {

	private static final long serialVersionUID = -3603692268523804502L;

	private int id;
	private int processId;
	private String approvalIdObtained;
	private Integer associatedStudyApproval1;
	private Integer associatedStudyApproval2;
	private Integer associatedStudyApproval3;
	private String title;
	private String description;
	private Date createdOn;
	private Date modifiedOn;
	private String createdBy;
	private String modifiedBy;
	private String obtained;
	private List<Integer> associatedApprovals;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the processId
	 */
	public int getProcessId() {
		return processId;
	}

	/**
	 * @param processId
	 *            the processId to set
	 */
	public void setProcessId(int processId) {
		this.processId = processId;
	}

	/**
	 * @return the approvalIdObtained
	 */
	public String getApprovalIdObtained() {
		return approvalIdObtained;
	}

	/**
	 * @param approvalIdObtained
	 *            the approvalIdObtained to set
	 */
	public void setApprovalIdObtained(String approvalIdObtained) {
		this.approvalIdObtained = approvalIdObtained;
	}

	/**
	 * @return the associatedStudyApproval1
	 */
	public Integer getAssociatedStudyApproval1() {
		return associatedStudyApproval1;
	}

	/**
	 * @param associatedStudyApproval1
	 *            the associatedStudyApproval1 to set
	 */
	public void setAssociatedStudyApproval1(Integer associatedStudyApproval1) {
		this.associatedStudyApproval1 = associatedStudyApproval1;
	}

	/**
	 * @return the associatedStudyApproval2
	 */
	public Integer getAssociatedStudyApproval2() {
		return associatedStudyApproval2;
	}

	/**
	 * @param associatedStudyApproval2
	 *            the associatedStudyApproval2 to set
	 */
	public void setAssociatedStudyApproval2(Integer associatedStudyApproval2) {
		this.associatedStudyApproval2 = associatedStudyApproval2;
	}

	/**
	 * @return the associatedStudyApproval3
	 */
	public Integer getAssociatedStudyApproval3() {
		return associatedStudyApproval3;
	}

	/**
	 * @param associatedStudyApproval3
	 *            the associatedStudyApproval3 to set
	 */
	public void setAssociatedStudyApproval3(Integer associatedStudyApproval3) {
		this.associatedStudyApproval3 = associatedStudyApproval3;
	}

	/**
	 * @return the title
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * @param title
	 *            the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * @return the createdOn
	 */
	public Date getCreatedOn() {
		return createdOn;
	}

	/**
	 * @param createdOn
	 *            the createdOn to set
	 */
	public void setCreatedOn(Date createdOn) {
		this.createdOn = createdOn;
	}

	/**
	 * @return the modifiedOn
	 */
	public Date getModifiedOn() {
		return modifiedOn;
	}

	/**
	 * @param modifiedOn
	 *            the modifiedOn to set
	 */
	public void setModifiedOn(Date modifiedOn) {
		this.modifiedOn = modifiedOn;
	}

	/**
	 * @return the createdBy
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @param createdBy
	 *            the createdBy to set
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * @return the modifiedBy
	 */
	public String getModifiedBy() {
		return modifiedBy;
	}

	/**
	 * @param modifiedBy
	 *            the modifiedBy to set
	 */
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	/**
	 * @return the obtained
	 */
	public String getObtained() {
		return obtained;
	}

	/**
	 * @param obtained
	 *            the obtained to set
	 */
	public void setObtained(String obtained) {
		this.obtained = obtained;
	}

	/**
	 * @return the associatedApprovals
	 */
	public List<Integer> getAssociatedApprovals() {
		return associatedApprovals;
	}

	/**
	 * @param associatedApprovals
	 *            the associatedApprovals to set
	 */
	public void setAssociatedApprovals(List<Integer> associatedApprovals) {
		this.associatedApprovals = associatedApprovals;
	}
}
